<?php
// File name: settings.php
// File location: /home/apimedi1/public_html/api/v1/routes/panic/settings.php

require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../../../../secure/config_v2.php';
require_once __DIR__ . '/../../../../../secure/database_router_v2.php';

$response = new Response();
$method = $_SERVER['REQUEST_METHOD'];

$conn_panic = getDatabaseConnection('panic_service', 'GBL');
if (!$conn_panic) {
    $response->json(['error' => 'Database connection failed'], 500);
}

if ($method !== 'GET') {
    $response->json(['error' => 'Method not allowed'], 405);
}

requireJWT(); // Admin check can be added

$stmt = $conn_panic->prepare("SELECT setting_name, setting_value FROM panic_service_settings");
$stmt->execute();
$result = $stmt->get_result();
$settings = [];
while ($row = $result->fetch_assoc()) {
    $settings[] = $row;
}
$stmt->close();

$response->json($settings, 200);