<?php
// File name: sti_history.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/sti_history.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        sh.id,
        sh.consultation_id,
        sh.sti_type_id,
        st.type_name AS sti_name,
        sh.diagnosis_status,
        sh.diagnosis_date,
        sh.treatment_status,
        sh.treatment_details,
        sh.complications,
        sh.additional_notes,
        sh.validation_status,
        sh.validated_by_user_id,
        sh.validated_by_role_type,
        sh.validated_at,
        sh.validation_reason,
        sh.flagged_as_error,
        sh.error_notes,
        sh.created_by_user_id,
        sh.created_by_role_type,
        sh.created_at,
        sh.updated_by_user_id,
        sh.updated_by_role_type,
        sh.updated_at,
        sh.update_reason
    FROM sti_history sh
    LEFT JOIN sti_types st ON sh.sti_type_id = st.id
    WHERE sh.patient_id = ?
      AND sh.deleted_at IS NULL
    ORDER BY sh.diagnosis_date DESC, sh.id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$sti_history = [];
while ($row = $result->fetch_assoc()) {
    $row['diagnosis_date'] = $row['diagnosis_date'] ? date('Y-m-d', strtotime($row['diagnosis_date'])) : null;
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['created_at'] = $row['created_at'] ? date('Y-m-d H:i:s', strtotime($row['created_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    $sti_history[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalRecords' => count($sti_history),
    'stiHistory' => $sti_history,
    'retrievedAt' => date('c')
]);
?>