<?php
// File name: genetic_history.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/genetic_history.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

// Main genetic history
$stmt = $conn->prepare("
    SELECT 
        gh.id,
        gh.genetic_counseling_provided,
        gh.family_risk_assessment,
        gh.validation_status,
        gh.validated_by_user_id,
        gh.validated_by_role_type,
        gh.validated_at,
        gh.validation_reason,
        gh.recorded_by_user_id,
        gh.recorded_by_role_type,
        gh.recorded_at,
        gh.updated_by_user_id,
        gh.updated_by_role_type,
        gh.updated_at,
        gh.update_reason
    FROM genetic_history gh
    WHERE gh.patient_id = ?
      AND gh.deleted_at IS NULL
    ORDER BY gh.recorded_at DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$genetic_records = [];
while ($row = $result->fetch_assoc()) {
    $history_id = $row['id'];

    // Format dates
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    // FIXED: Correct column name → genetic_history_id
    $test_stmt = $conn->prepare("
        SELECT 
            gt.id,
            gt.test_type_id,
            tt.test_type AS test_name,
            gt.test_date,
            gt.test_results,
            gt.test_results_summary,
            gt.validation_status,
            gt.validated_by_user_id,
            gt.validated_by_role_type,
            gt.validated_at,
            gt.recorded_by_user_id,
            gt.recorded_by_role_type,
            gt.recorded_at,
            gtsd.coverage_depth,
            gtsd.variant_count,
            gtsd.pathogenic_variants,
            gtsd.interpretation_notes,
            gtsd.genes_included,
            gtsd.detection_methods,
            gtsd.results_summary,
            gtsd.carrier_status,
            gtsd.implications,
            gtsd.screening_stage,
            gtsd.detected_conditions,
            gtsd.screened_conditions,
            gtsd.follow_up_actions,
            gtsd.medications_assessed,
            gtsd.recommendations,
            gtsd.test_description
        FROM genetic_tests gt
        LEFT JOIN genetic_test_types tt ON gt.test_type_id = tt.id
        LEFT JOIN genetic_test_specific_details gtsd ON gt.id = gtsd.genetic_test_id AND gtsd.deleted_at IS NULL
        WHERE gt.genetic_history_id = ?   -- ← FIXED: was genetics_history_id
          AND gt.deleted_at IS NULL
        ORDER BY gt.test_date DESC
    ");

    if (!$test_stmt) {
        $row['geneticTests'] = [];
        $genetic_records[] = $row;
        continue; // Skip this history if query fails
    }

    $test_stmt->bind_param("i", $history_id);
    $test_stmt->execute();
    $test_result = $test_stmt->get_result();

    $tests = [];
    while ($test_row = $test_result->fetch_assoc()) {
        $test_id = $test_row['id'];

        $test_row['test_date'] = $test_row['test_date'] ? date('Y-m-d', strtotime($test_row['test_date'])) : null;
        $test_row['validated_at'] = $test_row['validated_at'] ? date('Y-m-d H:i:s', strtotime($test_row['validated_at'])) : null;
        $test_row['recorded_at'] = $test_row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($test_row['recorded_at'])) : null;

        // Files
        $file_stmt = $conn->prepare("SELECT file_path, file_type, uploaded_at FROM genetic_test_files WHERE genetic_test_id = ? AND deleted_at IS NULL");
        if ($file_stmt) {
            $file_stmt->bind_param("i", $test_id);
            $file_stmt->execute();
            $file_result = $file_stmt->get_result();
            $test_row['files'] = $file_result->fetch_all(MYSQLI_ASSOC);
            $file_stmt->close();
        } else {
            $test_row['files'] = [];
        }

        // Results
        $result_stmt = $conn->prepare("SELECT parameter_name, parameter_value, units, reference_range FROM genetic_test_results WHERE genetic_test_id = ? AND deleted_at IS NULL");
        if ($result_stmt) {
            $result_stmt->bind_param("i", $test_id);
            $result_stmt->execute();
            $result_result = $result_stmt->get_result();
            $test_row['results'] = $result_result->fetch_all(MYSQLI_ASSOC);
            $result_stmt->close();
        } else {
            $test_row['results'] = [];
        }

        $tests[] = $test_row;
    }
    $test_stmt->close();

    $row['geneticTests'] = $tests;
    $genetic_records[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalRecords' => count($genetic_records),
    'geneticHistory' => $genetic_records,
    'retrievedAt' => date('c')
]);
?>