<?php
// File name: emergency_contacts.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/emergency_contacts.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

// Get patient's region and connect to correct medical DB
$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        id,
        contact_type,
        family_member_id,
        first_name,
        last_name,
        relationship_id,
        phone_number,
        email,
        address,
        is_primary_contact,
        notes,
        validation_status,
        validated_by_user_id,
        validated_by_role_type,
        validated_at,
        validation_reason,
        flagged_as_error,
        error_notes,
        recorded_by_user_id,
        recorded_by_role_type,
        recorded_at,
        updated_by_user_id,
        updated_by_role_type,
        updated_at,
        update_reason
    FROM emergency_contacts 
    WHERE patient_id = ?
      AND deleted_at IS NULL
    ORDER BY is_primary_contact DESC, id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$emergency_contacts = [];
while ($row = $result->fetch_assoc()) {
    // Format dates
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    $emergency_contacts[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalContacts' => count($emergency_contacts),
    'emergencyContacts' => $emergency_contacts,
    'retrievedAt' => date('c')
]);
?>