<?php
// File name: diagnoses.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/diagnoses.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

// Get patient's region and connect to correct medical DB
$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        d.id,
        d.consultation_id,
        d.facility_admission_id,
        d.provider_id,
        d.diagnosis_code,
        d.coding_system_id,
        d.diagnosis_description,
        d.diagnosis_type,
        d.diagnosis_date,
        d.diagnosis_status,
        d.severity,
        d.staging_system_id,
        d.date_of_onset,
        d.previous_diagnosis,
        d.diagnosis_confirmation,
        d.flagged_as_error,
        d.error_notes,
        d.validation_status,
        d.validated_by_user_id,
        d.validated_by_role_type,
        d.validated_at,
        d.validation_reason,
        d.recorded_by_user_id,
        d.recorded_by_role_type,
        d.recorded_at,
        d.updated_by_user_id,
        d.updated_by_role_type,
        d.updated_at,
        d.update_reason,
        d.notes
    FROM diagnoses d
    WHERE d.patient_id = ?
      AND d.deleted_at IS NULL
    ORDER BY d.diagnosis_date DESC, d.id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$diagnoses = [];
while ($row = $result->fetch_assoc()) {
    $diagnosis_id = $row['id'];

    // Format dates
    $row['diagnosis_date'] = $row['diagnosis_date'] ? date('Y-m-d H:i:s', strtotime($row['diagnosis_date'])) : null;
    $row['date_of_onset'] = $row['date_of_onset'] ? date('Y-m-d', strtotime($row['date_of_onset'])) : null;
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    // Fetch staging system name if staging_system_id exists
    $staging_system = null;
    if ($row['staging_system_id']) {
        $stage_stmt = $conn->prepare("SELECT system_name FROM disease_staging_systems WHERE id = ?");
        $stage_stmt->bind_param("i", $row['staging_system_id']);
        $stage_stmt->execute();
        $stage_result = $stage_stmt->get_result();
        $stage_row = $stage_result->fetch_assoc();
        $staging_system = $stage_row['system_name'] ?? null;
        $stage_stmt->close();
    }
    $row['staging_system_name'] = $staging_system;

    // Fetch diagnosis stages separately
    $stage_stmt = $conn->prepare("
        SELECT 
            id,
            staging_system_id,
            stage_label,
            stage_details,
            flagged_as_error,
            error_notes,
            validation_status,
            validated_at,
            recorded_at,
            updated_at
        FROM diagnosis_stages 
        WHERE diagnosis_id = ?
          AND deleted_at IS NULL
        ORDER BY id ASC
    ");
    if ($stage_stmt) {
        $stage_stmt->bind_param("i", $diagnosis_id);
        $stage_stmt->execute();
        $stage_result = $stage_stmt->get_result();

        $stages = [];
        while ($s_row = $stage_result->fetch_assoc()) {
            $s_row['validated_at'] = $s_row['validated_at'] ? date('Y-m-d H:i:s', strtotime($s_row['validated_at'])) : null;
            $s_row['recorded_at'] = $s_row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($s_row['recorded_at'])) : null;
            $s_row['updated_at'] = $s_row['updated_at'] ? date('Y-m-d H:i:s', strtotime($s_row['updated_at'])) : null;

            $stages[] = $s_row;
        }
        $stage_stmt->close();
    } else {
        $stages = [];
    }

    $row['stages'] = $stages;

    $diagnoses[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalDiagnoses' => count($diagnoses),
    'diagnoses' => $diagnoses,
    'retrievedAt' => date('c')
]);
?>