<?php
// File name: birth_history.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/birth_history.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

// Get patient's region and connect to correct medical DB
$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        id,
        consultation_id,
        birth_date,
        birth_weight,
        birth_length,
        head_circumference,
        gestational_age_weeks,
        delivery_method,
        other_delivery_method,
        birth_order,
        multiple_birth,
        other_multiple_birth,
        sex_at_birth,
        other_sex,
        place_of_birth,
        other_place_of_birth,
        attended_by,
        other_attended_by,
        prenatal_care_details,
        apgar_score_1,
        apgar_score_5,
        apgar_score_10,
        nicu_admission,
        nicu_stay_duration,
        resuscitation,
        other_resuscitation,
        complications,
        congenital_anomalies,
        notes,
        validation_status,
        validated_by_user_id,
        validated_by_role_type,
        validated_at,
        validation_reason,
        flagged_as_error,
        error_notes,
        recorded_by_user_id,
        recorded_by_role_type,
        recorded_at,
        updated_by_user_id,
        updated_by_role_type,
        updated_at,
        update_reason
    FROM birth_history 
    WHERE patient_id = ?
      AND deleted_at IS NULL
    ORDER BY birth_date DESC, id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$birth_history = [];
while ($row = $result->fetch_assoc()) {
    // Format dates
    $row['birth_date'] = $row['birth_date'] ? date('Y-m-d', strtotime($row['birth_date'])) : null;
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    $birth_history[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalRecords' => count($birth_history),
    'birthHistory' => $birth_history,
    'retrievedAt' => date('c')
]);
?>