<?php
// File name: apple_health.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/apple_health.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

// Get patient's region and connect to correct medical DB
$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        id,
        health_metric_type,
        value,
        unit,
        recorded_at,
        category_value,
        metadata,
        source,
        imported_at,
        recorded_by_user_id,
        updated_by_user_id,
        updated_by_role_type,
        updated_at,
        update_reason
    FROM apple_health_data 
    WHERE patient_id = ?
      AND deleted_at IS NULL
    ORDER BY recorded_at DESC, id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$health_data = [];
while ($row = $result->fetch_assoc()) {
    // Format dates
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['imported_at'] = $row['imported_at'] ? date('Y-m-d H:i:s', strtotime($row['imported_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    // Parse metadata if JSON
    $row['metadata'] = json_decode($row['metadata'], true) ?? $row['metadata'];

    $health_data[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalRecords' => count($health_data),
    'appleHealthData' => $health_data,
    'retrievedAt' => date('c')
]);
?>