<?php
// File name: anthropometry.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/anthropometry.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

// Get patient's region and connect to correct medical DB
$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        id,
        consultation_id,
        height,
        weight,
        bmi,
        waist_circumference,
        hip_circumference,
        waist_to_hip_ratio,
        waist_to_height_ratio,
        body_fat_percentage,
        visceral_fat_percentage,
        arm_circumference,
        forearm_circumference,
        head_circumference,
        sitting_height,
        skinfold_thickness,
        muac,
        thigh_circumference,
        calf_circumference,
        chest_circumference,
        handgrip_strength,
        measurement_date,
        recorded_by_user_id,
        recorded_by_role_type,
        recorded_at,
        updated_by_user_id,
        updated_by_role_type,
        updated_at,
        update_reason
    FROM anthropometry 
    WHERE patient_id = ?
      AND deleted_at IS NULL
    ORDER BY measurement_date DESC, id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$anthropometry = [];
while ($row = $result->fetch_assoc()) {
    // Format dates
    $row['measurement_date'] = $row['measurement_date'] ? date('Y-m-d', strtotime($row['measurement_date'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;

    $anthropometry[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalRecords' => count($anthropometry),
    'anthropometry' => $anthropometry,
    'retrievedAt' => date('c')
]);
?>