<?php
// File name: anaesthesia.php
// File location: /home/apimedi1/public_html/api/v1/routes/medical/anaesthesia.php

require_once __DIR__ . '/../../middleware/jwt.php';

$userId = requireJWT();
$patientId = (int)($_GET['patient_id'] ?? ($uri_parts[2] ?? 0));
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

// Get patient's region and connect to correct medical DB
$region = getPatientRegion($patientId);
$conn = getDatabaseConnection('medical_data', $region);

$stmt = $conn->prepare("
    SELECT 
        ar.id,
        ar.procedure_id,
        ar.anaesthesia_type_id,
        ar.dosage,
        ar.start_time,
        ar.end_time,
        ar.notes,
        ar.validation_status,
        ar.validated_by_user_id,
        ar.validated_by_role_type,
        ar.validated_at,
        ar.validation_reason,
        ar.flagged_as_error,
        ar.error_notes,
        ar.error_flagged_by_user_id,
        ar.error_flagged_by_role_type,
        ar.error_flagged_at,
        ar.recorded_by_user_id,
        ar.recorded_by_role_type,
        ar.recorded_at,
        ar.updated_by_user_id,
        ar.updated_by_role_type,
        ar.updated_at,
        ar.update_reason,
        ar.deleted_by_user_id,
        ar.deleted_by_role_type,
        ar.deleted_at,
        ar.delete_reason,
        -- Join procedure details for value
        p.procedure_name,
        p.procedure_coding_system_id,
        p.provider_id,
        p.description,
        p.date_performed,
        p.status AS procedure_status,
        p.notes AS procedure_notes
    FROM anaesthesia_records ar
    LEFT JOIN procedures p ON ar.procedure_id = p.id AND p.deleted_at IS NULL
    WHERE p.patient_id = ? AND ar.deleted_at IS NULL
    ORDER BY ar.start_time DESC, ar.id DESC
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("i", $patientId);
$stmt->execute();
$result = $stmt->get_result();

$anaesthesia_records = [];
while ($row = $result->fetch_assoc()) {
    // Format dates
    $row['start_time'] = $row['start_time'] ? date('Y-m-d H:i:s', strtotime($row['start_time'])) : null;
    $row['end_time'] = $row['end_time'] ? date('Y-m-d H:i:s', strtotime($row['end_time'])) : null;
    $row['validated_at'] = $row['validated_at'] ? date('Y-m-d H:i:s', strtotime($row['validated_at'])) : null;
    $row['error_flagged_at'] = $row['error_flagged_at'] ? date('Y-m-d H:i:s', strtotime($row['error_flagged_at'])) : null;
    $row['recorded_at'] = $row['recorded_at'] ? date('Y-m-d H:i:s', strtotime($row['recorded_at'])) : null;
    $row['updated_at'] = $row['updated_at'] ? date('Y-m-d H:i:s', strtotime($row['updated_at'])) : null;
    $row['deleted_at'] = $row['deleted_at'] ? date('Y-m-d H:i:s', strtotime($row['deleted_at'])) : null;
    $row['date_performed'] = $row['date_performed'] ? date('Y-m-d', strtotime($row['date_performed'])) : null;

    $anaesthesia_records[] = $row;
}

$stmt->close();

(new Response)->json([
    'patientId' => $patientId,
    'region' => $region,
    'totalRecords' => count($anaesthesia_records),
    'anaesthesiaRecords' => $anaesthesia_records,
    'retrievedAt' => date('c')
]);
?>