<?php
// File name: tests.php
// File location: /home/apimedi1/public_html/api/v1/routes/lab/tests.php
require_once __DIR__ . '/../../middleware/jwt.php';

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    (new Response)->json(['error' => 'Method Not Allowed'], 405);
}

requireJWT();

// Retrieve payload to get region
$header = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
preg_match('/Bearer\s+(\S+)/', $header, $matches);
$payload = validateJWT($matches[1] ?? '');
$region = $payload['regionCode'] ?? 'NA';

$conn = getDatabaseConnection('lab_tests', $region);

if (!$conn) {
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

$stmt = $conn->prepare("
    SELECT 
        lt.id, lt.test_name, lt.test_code, lt.category_id, lt.sample_type_id, lt.panel_id,
        lt.sample_collection_method, lt.sample_volume, lt.sample_handling_instructions,
        lt.stability, lt.storage_requirements, lt.sample_container_id, lt.facility_id,
        lt.reference_range, lt.units_of_measurement_id, lt.critical_values, lt.interpretation_guidelines,
        lt.validation_status, lt.validated_by_user_id, lt.validated_by_role_type, lt.validated_at,
        lt.validation_reason, lt.flagged_as_error, lt.error_notes, lt.error_flagged_by_user_id,
        lt.error_flagged_by_role_type, lt.error_flagged_at, lt.system_created_at, lt.recorded_by_user_id,
        lt.recorded_by_role_type, lt.recorded_at, lt.updated_by_user_id, lt.updated_by_role_type,
        lt.updated_at, lt.update_reason, lt.deleted_by_user_id, lt.deleted_by_role_type,
        lt.deleted_at, lt.delete_reason, lt.result_data_type, lt.qualitative_options,
        tc.category_name, st.sample_type, sc.container_type, p.panel_name
    FROM lab_tests lt
    LEFT JOIN test_categories tc ON lt.category_id = tc.id
    LEFT JOIN sample_types st ON lt.sample_type_id = st.id
    LEFT JOIN sample_containers sc ON lt.sample_container_id = sc.id
    LEFT JOIN panels p ON lt.panel_id = p.id
    WHERE lt.is_deleted = 0
");

if (!$stmt) {
    (new Response)->json(['error' => 'Query preparation failed: ' . $conn->error], 500);
}

$stmt->execute();
$result = $stmt->get_result();
$tests = $result->fetch_all(MYSQLI_ASSOC);
$stmt->close();

(new Response)->json($tests);
?>