<?php
// File name: vaccinations.php
// File location: /home/apimedi1/public_html/api/v1/routes/emi/vaccinations.php
require_once __DIR__ . '/../../utils/jwt.php';
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/region.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';

$userId = requireJWT();
$patientId = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$regionCode = getPatientRegion($patientId);
if (!$regionCode) {
    (new Response)->json(['error' => 'Region not found'], 404);
}

$connMainGlobal = getDatabaseConnection('main', 'GBL');
$connMedicalRegion = getDatabaseConnection('medical_data', $regionCode);

if (!$connMainGlobal || !$connMedicalRegion) {
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

// Fetch QR visibility
$sqlQr = "SELECT visibility_vaccinations FROM user_qr_codes WHERE user_id = (SELECT user_id FROM patients WHERE id = ?) LIMIT 1";
$stmtQr = $connMainGlobal->prepare($sqlQr);
$stmtQr->bind_param('i', $patientId);
$stmtQr->execute();
$resQr = $stmtQr->get_result();
$qrRow = $resQr->fetch_assoc();
$stmtQr->close();

if ($qrRow['visibility_vaccinations'] == 0) {
    (new Response)->json(['error' => 'Access denied due to visibility settings'], 403);
}

// Fetch vaccinations
$vaccinations = [];
$onlyValidated = isset($_GET['only_validated']) && $_GET['only_validated'] === 'true';
$whereV = $onlyValidated ? " AND vh.validation_status='Validated'" : "";
$sqlVacc = "SELECT vh.id, vh.vaccination_type, vh.vaccination_date, vh.vaccine_name, vh.dose, vh.frequency, vh.route 
            FROM vaccinations_history vh WHERE vh.patient_id=? AND vh.deleted_at IS NULL $whereV ORDER BY vh.vaccination_date DESC";
$stmVacc = $connMedicalRegion->prepare($sqlVacc);
$stmVacc->bind_param('i', $patientId);
$stmVacc->execute();
$rv = $stmVacc->get_result();
while ($vac = $rv->fetch_assoc()) {
    $vaccId = (int)$vac['id'];
    $boosters = [];
    $whereB = $onlyValidated ? " AND vb.validation_status='Validated'" : "";
    $sqlBoost = "SELECT vb.booster_date, vb.dose, vb.frequency, vb.route, vb.side_effects 
                 FROM vaccination_boosters_history vb WHERE vb.vaccination_history_id=? AND vb.deleted_at IS NULL $whereB";
    $stmBoost = $connMedicalRegion->prepare($sqlBoost);
    $stmBoost->bind_param('i', $vaccId);
    $stmBoost->execute();
    $rb = $stmBoost->get_result();
    while ($bst = $rb->fetch_assoc()) {
        $boosters[] = $bst;
    }
    $stmBoost->close();
    $vac['boosters'] = $boosters;
    $vaccinations[] = $vac;
}
$stmVacc->close();

(new Response)->json(['vaccinations' => $vaccinations], !empty($vaccinations) ? 200 : 404);
?>