<?php
// File name: haematology.php
// File location: /home/apimedi1/public_html/api/v1/routes/emi/haematology.php
require_once __DIR__ . '/../../utils/jwt.php';
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/region.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';

$userId = requireJWT();
$patientId = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$regionCode = getPatientRegion($patientId);
if (!$regionCode) {
    (new Response)->json(['error' => 'Region not found'], 404);
}

$connMainGlobal = getDatabaseConnection('main', 'GBL');
$connMedicalRegion = getDatabaseConnection('medical_data', $regionCode);

if (!$connMainGlobal || !$connMedicalRegion) {
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

// Fetch QR visibility
$sqlQr = "SELECT visibility_haematology FROM user_qr_codes WHERE user_id = (SELECT user_id FROM patients WHERE id = ?) LIMIT 1";
$stmtQr = $connMainGlobal->prepare($sqlQr);
$stmtQr->bind_param('i', $patientId);
$stmtQr->execute();
$resQr = $stmtQr->get_result();
$qrRow = $resQr->fetch_assoc();
$stmtQr->close();

if ($qrRow['visibility_haematology'] == 0) {
    (new Response)->json(['error' => 'Access denied due to visibility settings'], 403);
}

// Fetch haematology
$haema = null;
$onlyValidated = isset($_GET['only_validated']) && $_GET['only_validated'] === 'true';
$where = $onlyValidated ? " AND deleted_at IS NULL AND validation_status='Validated'" : " AND deleted_at IS NULL";
$sqlHaema = "SELECT blood_group, rh_factor, blood_group_test_date, transfusion_history, last_transfusion_date, transfusion_type, transfusion_reactions 
             FROM haematology_history WHERE patient_id=? $where ORDER BY recorded_at DESC LIMIT 1";
$stmH = $connMedicalRegion->prepare($sqlHaema);
$stmH->bind_param('i', $patientId);
$stmH->execute();
$rH = $stmH->get_result();
if ($rowH = $rH->fetch_assoc()) {
    $haema = $rowH;
}
$stmH->close();

(new Response)->json($haema ?: ['message' => 'No data found'], $haema ? 200 : 404);
?>