<?php
// File name: facility-admissions.php
// File location: /home/apimedi1/public_html/api/v1/routes/emi/facility-admissions.php
require_once __DIR__ . '/../../utils/jwt.php';
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/region.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';

$userId = requireJWT();
$patientId = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$regionCode = getPatientRegion($patientId);
if (!$regionCode) {
    (new Response)->json(['error' => 'Region not found'], 404);
}

$connMainGlobal = getDatabaseConnection('main', 'GBL');
$connMedicalRegion = getDatabaseConnection('medical_data', $regionCode);

if (!$connMainGlobal || !$connMedicalRegion) {
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

// Fetch QR visibility
$sqlQr = "SELECT visibility_facility_admissions FROM user_qr_codes WHERE user_id = (SELECT user_id FROM patients WHERE id = ?) LIMIT 1";
$stmtQr = $connMainGlobal->prepare($sqlQr);
$stmtQr->bind_param('i', $patientId);
$stmtQr->execute();
$resQr = $stmtQr->get_result();
$qrRow = $resQr->fetch_assoc();
$stmtQr->close();

if ($qrRow['visibility_facility_admissions'] == 0) {
    (new Response)->json(['error' => 'Access denied due to visibility settings'], 403);
}

// Fetch admissions
$admissions = [];
$onlyValidated = isset($_GET['only_validated']) && $_GET['only_validated'] === 'true';
$where = $onlyValidated ? " AND deleted_at IS NULL AND validation_status='Validated'" : " AND deleted_at IS NULL";
$sqlFA = "SELECT admission_date, discharge_date, facility_id, reason_for_admission, treatment_plan 
          FROM facility_admissions WHERE patient_id=? $where ORDER BY admission_date DESC";
$stmtFA = $connMedicalRegion->prepare($sqlFA);
$stmtFA->bind_param('i', $patientId);
$stmtFA->execute();
$resFA = $stmtFA->get_result();
while ($fa = $resFA->fetch_assoc()) {
    $facilityName = 'Unknown';
    if ($fa['facility_id']) {
        $sqlFacility = "SELECT facility_name FROM facilities WHERE facility_id=? LIMIT 1";
        $stmtFacility = $connMainGlobal->prepare($sqlFacility);
        $stmtFacility->bind_param('i', $fa['facility_id']);
        $stmtFacility->execute();
        $resFacility = $stmtFacility->get_result();
        if ($rowFacility = $resFacility->fetch_assoc()) {
            $facilityName = $rowFacility['facility_name'];
        }
        $stmtFacility->close();
    }
    $fa['facility_name'] = $facilityName;
    $admissions[] = $fa;
}
$stmtFA->close();

(new Response)->json(['admissions' => $admissions], !empty($admissions) ? 200 : 404);
?>