<?php
// File name: emergency-contacts.php
// File location: /home/apimedi1/public_html/api/v1/routes/emi/emergency-contacts.php
require_once __DIR__ . '/../../utils/jwt.php';
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/region.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';

$userId = requireJWT();
$patientId = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$regionCode = getPatientRegion($patientId);
if (!$regionCode) {
    (new Response)->json(['error' => 'Region not found'], 404);
}

$connMainGlobal = getDatabaseConnection('main', 'GBL');
$connMedicalRegion = getDatabaseConnection('medical_data', $regionCode);

if (!$connMainGlobal || !$connMedicalRegion) {
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

// Fetch QR visibility
$sqlQr = "SELECT visibility_emergency_contacts FROM user_qr_codes WHERE user_id = (SELECT user_id FROM patients WHERE id = ?) LIMIT 1";
$stmtQr = $connMainGlobal->prepare($sqlQr);
$stmtQr->bind_param('i', $patientId);
$stmtQr->execute();
$resQr = $stmtQr->get_result();
$qrRow = $resQr->fetch_assoc();
$stmtQr->close();

if ($qrRow['visibility_emergency_contacts'] == 0) {
    (new Response)->json(['error' => 'Access denied due to visibility settings'], 403);
}

// Fetch emergency contacts
$emContacts = [];
$onlyValidated = isset($_GET['only_validated']) && $_GET['only_validated'] === 'true';
$where = $onlyValidated ? " AND ec.deleted_at IS NULL AND ec.validation_status='Validated'" : " AND ec.deleted_at IS NULL";
$sqlEC = "SELECT ec.first_name, ec.last_name, lr.relationship_name, ec.phone_number, ec.is_primary_contact 
          FROM emergency_contacts ec LEFT JOIN lookup_relationships lr ON ec.relationship_id=lr.id 
          WHERE ec.patient_id=? $where ORDER BY ec.system_created_at DESC";
$stmEC = $connMedicalRegion->prepare($sqlEC);
$stmEC->bind_param('i', $patientId);
$stmEC->execute();
$rec = $stmEC->get_result();
while ($er = $rec->fetch_assoc()) {
    $emContacts[] = $er;
}
$stmEC->close();

(new Response)->json(['emergency_contacts' => $emContacts], !empty($emContacts) ? 200 : 404);
?>