<?php
// File name: diagnoses.php
// File location: /home/apimedi1/public_html/api/v1/routes/emi/diagnoses.php
require_once __DIR__ . '/../../utils/jwt.php';
require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../utils/region.php';
require_once __DIR__ . '/../../utils/request.php';
require_once __DIR__ . '/../../handlers/Response.php';

$userId = requireJWT();
$patientId = isset($_GET['patient_id']) ? (int)$_GET['patient_id'] : 0;
if ($patientId <= 0) {
    (new Response)->json(['error' => 'Invalid patient ID'], 400);
}

$regionCode = getPatientRegion($patientId);
if (!$regionCode) {
    (new Response)->json(['error' => 'Region not found'], 404);
}

$connMainGlobal = getDatabaseConnection('main', 'GBL');
$connMedicalRegion = getDatabaseConnection('medical_data', $regionCode);
$connPrescriptions = getDatabaseConnection('prescriptions', $regionCode);
$connMedications = getDatabaseConnection('medications', $regionCode);

if (!$connMainGlobal || !$connMedicalRegion || !$connPrescriptions || !$connMedications) {
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

// Fetch QR visibility
$sqlQr = "SELECT visibility_diagnoses FROM user_qr_codes WHERE user_id = (SELECT user_id FROM patients WHERE id = ?) LIMIT 1";
$stmtQr = $connMainGlobal->prepare($sqlQr);
$stmtQr->bind_param('i', $patientId);
$stmtQr->execute();
$resQr = $stmtQr->get_result();
$qrRow = $resQr->fetch_assoc();
$stmtQr->close();

if ($qrRow['visibility_diagnoses'] == 0) {
    (new Response)->json(['error' => 'Access denied due to visibility settings'], 403);
}

// Fetch diagnoses
$diagnoses = [];
$onlyValidated = isset($_GET['only_validated']) && $_GET['only_validated'] === 'true';
$where = $onlyValidated ? " AND d.deleted_at IS NULL AND d.validation_status='Validated'" : " AND d.deleted_at IS NULL";
$sqlDiag = "SELECT d.id, d.diagnosis_date, d.diagnosis_code, cs.system_name, d.diagnosis_description, d.diagnosis_type, d.severity, d.diagnosis_confirmation 
            FROM diagnoses d LEFT JOIN coding_systems cs ON d.coding_system_id=cs.id 
            WHERE d.patient_id=? $where ORDER BY d.diagnosis_date DESC";
$stmD = $connMedicalRegion->prepare($sqlDiag);
$stmD->bind_param('i', $patientId);
$stmD->execute();
$rd = $stmD->get_result();
while ($dx = $rd->fetch_assoc()) {
    $diagId = (int)$dx['id'];
    $linkedPresc = [];
    $whereP = $onlyValidated ? " AND p.validation_status='Validated' AND pi.validation_status='Validated' AND pdl.validation_status='Validated'" : "";
    $sqlDiagPresc = "SELECT DISTINCT p.prescription_id, p.date_issued, p.status, p.notes 
                     FROM prescriptions p JOIN prescription_items pi ON p.prescription_id = pi.prescription_id 
                     JOIN prescription_diagnosis_link pdl ON pi.prescription_item_id = pdl.prescription_item_id 
                     WHERE p.patient_id = ? AND pdl.diagnosis_id = ? AND p.deleted_at IS NULL AND pdl.deleted_at IS NULL $whereP";
    $stmDiagPresc = $connPrescriptions->prepare($sqlDiagPresc);
    $stmDiagPresc->bind_param('ii', $patientId, $diagId);
    $stmDiagPresc->execute();
    $rdp = $stmDiagPresc->get_result();
    while ($dp = $rdp->fetch_assoc()) {
        $prescId = (int)$dp['prescription_id'];
        $items = [];
        $whereI = $onlyValidated ? " AND pi.validation_status='Validated'" : "";
        $sqlItems = "SELECT pi.drug_id, pi.dosage, pi.units, pi.frequency, pi.route, pi.duration, pi.duration_unit, pi.instructions 
                     FROM prescription_items pi WHERE pi.prescription_id=? AND pi.deleted_at IS NULL $whereI";
        $stmItems = $connPrescriptions->prepare($sqlItems);
        $stmItems->bind_param('i', $prescId);
        $stmItems->execute();
        $ri = $stmItems->get_result();
        while ($item = $ri->fetch_assoc()) {
            $drugName = 'Unknown';
            if ($item['drug_id']) {
                $drugId = (int)$item['drug_id'];
                $sqlDrug = "SELECT active_compound FROM drug_list WHERE drug_id=? LIMIT 1";
                $stmDrug = $connMedications->prepare($sqlDrug);
                $stmDrug->bind_param('i', $drugId);
                $stmDrug->execute();
                $rDrug = $stmDrug->get_result();
                if ($drugRow = $rDrug->fetch_assoc()) {
                    $drugName = $drugRow['active_compound'];
                }
                $stmDrug->close();
            }
            $item['drug_name'] = $drugName;
            $items[] = $item;
        }
        $stmItems->close();
        $dp['items'] = $items;
        $linkedPresc[] = $dp;
    }
    $stmDiagPresc->close();
    $dx['prescriptions'] = $linkedPresc;
    $diagnoses[] = $dx;
}
$stmD->close();

(new Response)->json(['diagnoses' => $diagnoses], !empty($diagnoses) ? 200 : 404);
?>