<?php
// File name: payments.php
// File location: /home/apimedi1/public_html/api/v1/routes/billing/payments.php

requireJWT();
$method = $_SERVER['REQUEST_METHOD'];
$response = new Response();
$user_id = $GLOBALS['auth_user_id'];

switch ($method) {
    case 'GET':
        // List payments
        $conn_billing = getConnBilling();
        $stmt = $conn_billing->prepare("SELECT * FROM payments WHERE user_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $payments = [];
        while ($row = $result->fetch_assoc()) {
            $payments[] = $row;
        }
        $response->json($payments);
        break;

    case 'POST':
        // Process payment
        $input = getJsonInput();
        $invoice_id = $input['invoice_id'] ?? null;
        $amount = $input['amount'] ?? null;
        $gateway_id = $input['gateway_id'] ?? null;

        if (!$invoice_id || !$amount || !$gateway_id) {
            $response->json(['error' => 'Missing required fields'], 400);
        }

        $conn_billing = getConnBilling();
        $stmt = $conn_billing->prepare("INSERT INTO payments (invoice_id, payment_date, amount, gateway_id, currency, status, user_id) VALUES (?, CURDATE(), ?, ?, ?, 'successful', ?)");
        $currency = 'USD'; // Default or from input
        $stmt->bind_param("idisi", $invoice_id, $amount, $gateway_id, $currency, $user_id);
        if ($stmt->execute()) {
            // Update invoice status to paid
            $upd_stmt = $conn_billing->prepare("UPDATE invoices SET status = 'paid' WHERE id = ?");
            $upd_stmt->bind_param("i", $invoice_id);
            $upd_stmt->execute();
            $response->json(['success' => true, 'payment_id' => $stmt->insert_id]);
        } else {
            $response->json(['error' => 'Payment failed'], 500);
        }
        break;

    default:
        $response->json(['error' => 'Method not allowed'], 405);
}