<?php
// File name: orders.php
// File location: /home/apimedi1/public_html/api/v1/routes/billing/orders.php

requireJWT();
$method = $_SERVER['REQUEST_METHOD'];
$response = new Response();
$user_id = $GLOBALS['auth_user_id'];

switch ($method) {
    case 'GET':
        // List orders
        $conn_billing = getConnBilling();
        $stmt = $conn_billing->prepare("SELECT * FROM orders WHERE user_id = ?");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $orders = [];
        while ($row = $result->fetch_assoc()) {
            $orders[] = $row;
        }
        $response->json($orders);
        break;

    case 'POST':
        // Create order
        $input = getJsonInput();
        $amount = $input['amount'] ?? null;
        $currency = $input['currency'] ?? 'USD';
        $payment_method = $input['payment_method'] ?? null;

        if (!$amount || !$payment_method) {
            $response->json(['error' => 'Missing required fields'], 400);
        }

        $conn_billing = getConnBilling();
        $order_number = 'ORD-' . time(); // Generate order number
        $stmt = $conn_billing->prepare("INSERT INTO orders (user_id, order_number, amount, currency, status, payment_method) VALUES (?, ?, ?, ?, 'pending', ?)");
        $stmt->bind_param("isds", $user_id, $order_number, $amount, $currency, $payment_method);
        if ($stmt->execute()) {
            $response->json(['success' => true, 'order_id' => $stmt->insert_id, 'order_number' => $order_number]);
        } else {
            $response->json(['error' => 'Failed to create order'], 500);
        }
        break;

    default:
        $response->json(['error' => 'Method not allowed'], 405);
}