<?php
// File name: balance.php
// File location: /home/apimedi1/public_html/api/v1/routes/affiliate/balance.php

require_once __DIR__ . '/../../middleware/jwt.php';
require_once __DIR__ . '/../../handlers/Response.php';
require_once __DIR__ . '/../../../../../secure/database_router_v2.php';

$user_id = requireJWT();
$user_id_str = (string)$user_id;

$conn = getDatabaseConnection('affiliates', 'GBL');
if (!$conn) {
    logError('Database connection failed for affiliate balance', 'Database', __FILE__, __LINE__);
    (new Response)->json(['error' => 'Database connection failed'], 500);
}

$method = $_SERVER['REQUEST_METHOD'];
$response = new Response();

if ($method !== 'GET') {
    $response->json(['error' => 'Method not allowed'], 405);
}

if (!isset($_GET['affiliate_id'])) {
    $response->json(['error' => 'Missing affiliate_id'], 400);
}
$aff_code = $_GET['affiliate_id'];

// Verify ownership
$stmt = $conn->prepare("SELECT affiliate_id FROM affiliates WHERE affiliate_id = ? AND user_id = ? AND deleted_at IS NULL");
$stmt->bind_param("ss", $aff_code, $user_id_str);
$stmt->execute();
$row = $stmt->get_result()->fetch_assoc();
if (!$row) {
    $response->json(['error' => 'Affiliate not found or unauthorized'], 403);
}
$affiliate_id = $row['affiliate_id'];
$stmt->close();

// Calculate balance: sum(credits) - sum(debits) for approved/posted transactions
$stmt = $conn->prepare("
    SELECT 
        SUM(CASE WHEN transaction_type = 'credit' AND status IN ('approved', 'posted') THEN amount ELSE 0 END) -
        SUM(CASE WHEN transaction_type = 'debit' AND status IN ('approved', 'posted') THEN amount ELSE 0 END) AS balance,
        currency
    FROM affiliate_ledger 
    WHERE affiliate_id = ?
    GROUP BY currency
");
$stmt->bind_param("s", $affiliate_id);
$stmt->execute();
$result = $stmt->get_result();
$balances = [];
while ($row = $result->fetch_assoc()) {
    $balances[$row['currency']] = (float)$row['balance'];
}
$response->json(['balances' => $balances]);
$stmt->close();
?>