<?php
// File name: Response.php
// File location: /home/apimedi1/public_html/api/v1/handlers/Response.php

class Response {
    public function json($data, $status = 200) {
        http_response_code($status);
        $body = is_string($data) ? $data : json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        echo $body;

        $error_message = ($status >= 400) ? ($data['error'] ?? json_encode($data)) : null;
        $summary = substr($body, 0, 255);
        $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
        $user_id = $GLOBALS['auth_user_id'] ?? null;

        $conn = getConnAPI();
        if (!$conn) {
            exit;
        }

        $stmt = $conn->prepare("
            INSERT INTO api_responses 
            (request_id, status_code, response_body_summary, error_message, ip_address, user_id, created_at) 
            VALUES (?, ?, ?, ?, ?, ?, NOW())
        ");
        if (!$stmt) {
            exit;
        }

        $req_id = REQUEST_ID;
        $status_code = (int)$status;
        $user_id_value = $user_id !== null ? (int)$user_id : null;

        if ($user_id_value !== null) {
            $stmt->bind_param("sisssi", $req_id, $status_code, $summary, $error_message, $ip, $user_id_value);
        } else {
            $null_value = null;
            $stmt->bind_param("sissss", $req_id, $status_code, $summary, $error_message, $ip, $null_value);
        }

        $stmt->execute();
        $stmt->close();
        exit;
    }
}
?>