<?php
// File name: sms_bulksms.php
// File location: /home/apimedi1/public_html/api/v1/functions/notifications/sms_bulksms.php

/**
 * Sends a message using the BulkSMS API.
 */
function send_bulksms_message($post_body, $url, $username, $password) {
    $ch = curl_init();
    $headers = array(
        'Content-Type: application/json',
        'Authorization: Basic ' . base64_encode("$username:$password")
    );
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_body);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
   
    $server_response = curl_exec($ch);
    if ($server_response === false) {
        error_log("cURL error in send_bulksms_message: " . curl_error($ch));
    }
    $curl_info = curl_getinfo($ch);
    $output = array(
        'server_response' => $server_response,
        'http_status' => $curl_info['http_code'],
        'error' => curl_error($ch)
    );
    curl_close($ch);
    return $output;
}

/**
 * Inserts an SMS log entry into the audit database.
 * Now safely checks for $conn_audit and connects if missing.
 */
function log_sms($provider, $sms_id, $direction, $user_id, $to_number, $from_number, $body, $status, $price = null, $price_unit = null, $error_code = null, $error_message = null) {
    // Safely get the audit connection - this is the fix
    global $conn_audit;
    
    // If $conn_audit is not set or invalid, connect to audit GBL
    if (!$conn_audit || !($conn_audit instanceof mysqli) || $conn_audit->connect_error) {
        require_once __DIR__ . '/../../../../../secure/config_v2.php';
        require_once __DIR__ . '/../../../../../secure/database_router_v2.php';
        
        $conn_audit = getDatabaseConnection('audit', 'GBL');
        if (!$conn_audit) {
            error_log("SMS LOG ERROR: Could not connect to audit database (GBL). SMS not logged.");
            return false;
        }
    }

    $stmt = $conn_audit->prepare("
        INSERT INTO sms_logs
        (provider, sms_id, direction, recipient_id, to_number, from_number, body, status, price, price_unit, error_code, error_message, timestamp)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
    ");
    
    if ($stmt === false) {
        error_log("SMS LOG ERROR: Prepare failed - " . $conn_audit->error);
        return false;
    }

    // Handle NULLs properly
    $price = $price === null ? null : (float)$price;
    $price_unit = $price_unit ?? null;
    $error_code = $error_code ?? null;
    $error_message = $error_message ?? null;

    $stmt->bind_param(
        "ssssssssssss",
        $provider,
        $sms_id,
        $direction,
        $user_id,
        $to_number,
        $from_number,
        $body,
        $status,
        $price,
        $price_unit,
        $error_code,
        $error_message
    );

    $result = $stmt->execute();
    if (!$result) {
        error_log("SMS LOG ERROR: Execute failed - " . $stmt->error);
    }

    $stmt->close();
    return $result;
}
?>