<?php
// utils/jwt.php
// File Location: /home/apimedi1/public_html/api/v1/utils/jwt.php

// ONLY DEFINE IF NOT ALREADY DEFINED
if (!defined('JWT_SECRET')) {
    define('JWT_SECRET', 'x7k9m3p2q8r5t1v4w6u9y0z2a3b5c7d8e9f1g2h3j4k5l6m7n8o9p0q1r2s3t4u5v6w7x8y9z0');
    // CHANGE THIS IN PRODUCTION — 256-bit minimum
}

function base64url_encode($data) {
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}

function generateJWT($userId, $regionCode) {
    $header = base64url_encode(json_encode(['alg' => 'HS256', 'typ' => 'JWT']));
    $payload = base64url_encode(json_encode([
        'userId' => $userId,
        'regionCode' => $regionCode,
        'exp' => time() + 3600
    ]));
    $signature = base64url_encode(hash_hmac('sha256', "$header.$payload", JWT_SECRET, true));
    return "$header.$payload.$signature";
}

function validateJWT($token) {
    $parts = explode('.', $token);
    if (count($parts) !== 3) return false;
    list($headerB64, $payloadB64, $signatureB64) = $parts;
    $expected = base64url_encode(hash_hmac('sha256', "$headerB64.$payloadB64", JWT_SECRET, true));
    if (!hash_equals($expected, $signatureB64)) return false;
    $payload = json_decode(base64_decode($payloadB64), true);
    return ($payload && ($payload['exp'] ?? 0) > time()) ? $payload : false;
}