<?php
// File name: auth.php
// File location: /home/apimedi1/public_html/api/v1/routes/auth.php

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    (new Response)->json(['error' => 'Method Not Allowed'], 405);
}

$data = getJsonInput();
$email = $data['email'] ?? '';
$password = $data['password'] ?? '';

if (empty($email) || empty($password)) {
    (new Response)->json(['error' => 'Email and password required'], 400);
}

$conn = getConnMain();
$stmt = $conn->prepare("
    SELECT u.id, u.password, u.account_status, u.base_currency, u.timezone, u.first_name, u.middle_name, u.last_name, u.title,
           (SELECT datacenter_region_code FROM user_datacenter_regions WHERE user_id = u.id LIMIT 1) AS region_code,
           (SELECT GROUP_CONCAT(DISTINCT urd.role_type) FROM user_roles ur JOIN user_role_descriptions urd ON ur.role_id = urd.id WHERE ur.user_id = u.id) AS role_types,
           (SELECT GROUP_CONCAT(DISTINCT urd.role) FROM user_roles ur JOIN user_role_descriptions urd ON ur.role_id = urd.id WHERE ur.user_id = u.id) AS roles,
           (SELECT GROUP_CONCAT(DISTINCT ur.tenant_id) FROM user_roles ur WHERE ur.user_id = u.id) AS tenant_ids,
           (SELECT GROUP_CONCAT(DISTINCT ur.organization_id) FROM user_roles ur WHERE ur.user_id = u.id) AS organization_ids,
           (SELECT GROUP_CONCAT(DISTINCT ur.facility_id) FROM user_roles ur WHERE ur.user_id = u.id) AS facility_ids,
           (SELECT GROUP_CONCAT(DISTINCT ur.entity_id) FROM user_roles ur WHERE ur.user_id = u.id) AS entity_ids,
           (SELECT patient_id FROM users WHERE id = u.id) AS patient_id,
           (SELECT provider_id FROM users WHERE id = u.id) AS provider_id,
           (SELECT GROUP_CONCAT(DISTINCT ur.partner_id) FROM user_roles ur WHERE ur.user_id = u.id) AS partner_ids,
           (SELECT datacenter_region_code FROM user_datacenter_regions WHERE user_id = u.id AND user_role_type = 'Patient' LIMIT 1) AS patient_region_code,
           (SELECT datacenter_region_code FROM user_datacenter_regions WHERE user_id = u.id AND user_role_type = 'Provider' LIMIT 1) AS provider_region_code,
           (SELECT datacenter_region_code FROM user_datacenter_regions WHERE user_id = u.id AND user_role_type = 'Partner' LIMIT 1) AS partner_region_code
    FROM users u WHERE email = ?
");
if (!$stmt) {
    (new Response)->json(['error' => 'Database query failed: ' . $conn->error], 500);
}

$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    if (password_verify($password, $row['password'])) {
        $token = generateJWT($row['id'], $row['region_code'] ?? 'NA');

        // Full name construction
        $full_name = trim(($row['title'] ?? '') . ' ' . ($row['first_name'] ?? '') . ' ' . ($row['middle_name'] ?? '') . ' ' . ($row['last_name'] ?? ''));

        // Role types and roles as arrays
        $role_types = !empty($row['role_types']) ? array_unique(explode(',', $row['role_types'])) : [];
        $roles = !empty($row['roles']) ? array_unique(explode(',', $row['roles'])) : [];

        // Tenant, organization, facility, entity IDs as arrays (unique non-empty)
        $tenant_ids = !empty($row['tenant_ids']) ? array_unique(array_filter(explode(',', $row['tenant_ids']))) : [];
        $organization_ids = !empty($row['organization_ids']) ? array_unique(array_filter(explode(',', $row['organization_ids']))) : [];
        $facility_ids = !empty($row['facility_ids']) ? array_unique(array_filter(explode(',', $row['facility_ids']))) : [];
        $entity_ids = !empty($row['entity_ids']) ? array_unique(array_filter(explode(',', $row['entity_ids']))) : [];
        $partner_ids = !empty($row['partner_ids']) ? array_unique(array_filter(explode(',', $row['partner_ids']))) : [];

        // Fetch affiliate_id using getConnAffiliates()
        $affiliate_id = null;
        $conn_affiliates = getConnAffiliates();
        $aff_stmt = $conn_affiliates->prepare("SELECT affiliate_id FROM affiliates WHERE user_id = ? AND role_type = 'Partner' LIMIT 1");
        if ($aff_stmt) {
            $aff_stmt->bind_param("i", $row['id']);
            $aff_stmt->execute();
            $aff_stmt->bind_result($affiliate_id);
            $aff_stmt->fetch();
            $aff_stmt->close();
        }

        (new Response)->json([
            'token' => $token,
            'userId' => $row['id'],
            'regionCode' => $row['region_code'] ?? 'NA',
            'accountStatus' => $row['account_status'],
            'baseCurrency' => $row['base_currency'],
            'timezone' => $row['timezone'],
            'fullName' => $full_name,
            'roleTypes' => $role_types,
            'roles' => $roles,
            'tenantIds' => $tenant_ids,
            'organizationIds' => $organization_ids,
            'facilityIds' => $facility_ids,
            'entityIds' => $entity_ids,
            'patientId' => $row['patient_id'] ?? null,
            'patientRegionCode' => $row['patient_region_code'] ?? null,
            'providerId' => $row['provider_id'] ?? null,
            'providerRegionCode' => $row['provider_region_code'] ?? null,
            'partnerIds' => $partner_ids,
            'partnerRegionCode' => $row['partner_region_code'] ?? null,
            'affiliateId' => $affiliate_id ?? null,
            'message' => 'Login successful'
        ]);
    } else {
        (new Response)->json(['error' => 'Invalid credentials'], 401);
    }
} else {
    (new Response)->json(['error' => 'Invalid credentials'], 401);
}

$stmt->close();
?>