<?php
// File name: index.php
// File location: /home/apimedi1/public_html/api/v1/index.php

header('X-ModSecurity-Bypass: 1');
header('X-LiteSpeed-Bypass: 1');
header('X-HealthCheck: true');

if (strpos($_SERVER['HTTP_USER_AGENT'] ?? '', 'curl') !== false ||
    strpos($_SERVER['HTTP_USER_AGENT'] ?? '', 'Postman') !== false ||
    strpos($_SERVER['HTTP_USER_AGENT'] ?? '', 'Insomnia') !== false) {
    header('X-Allowed-Client: API-Tool');
}

require_once __DIR__ . '/../../../secure/config_v2.php';
require_once __DIR__ . '/../../../secure/database_router_v2.php';
require_once __DIR__ . '/middleware/rate_limiter.php';

// RATE LIMIT = 1 FOR TESTING (change to 5000 for production)
rateLimit(10);

// UNIQUE REQUEST_ID
if (!defined('REQUEST_ID')) {
    define('REQUEST_ID', uniqid('req_', true));
}

// LOG REQUEST BEFORE ROUTING
$conn = getConnAPI();
$method = $_SERVER['REQUEST_METHOD'];
$endpoint = $_SERVER['REQUEST_URI'];
$headers = json_encode(getallheaders());
$body_summary = substr(file_get_contents('php://input'), 0, 255);
$ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
$user_id = $GLOBALS['auth_user_id'] ?? null;

$req_id = REQUEST_ID;  // For reference passing

$stmt = $conn->prepare("INSERT INTO api_requests (request_id, method, endpoint, headers, body_summary, ip_address, user_id, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, NOW())");
if ($stmt) {
    $types = "sssssss";
    $user_id_param = $user_id !== null ? (int)$user_id : null;
    if ($user_id_param === null) {
        $types = "sssssss";  // s for null as string, but use null
    }
    $stmt->bind_param($types, $req_id, $method, $endpoint, $headers, $body_summary, $ip, $user_id_param);
    $stmt->execute();
    $stmt->close();
}

require_once __DIR__ . '/bootstrap/init.php';

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = trim(str_replace('/api/v1', '', $uri), '/');
$uri_parts = $uri ? explode('/', $uri) : [];

$response = new Response();

$route = implode('/', array_slice($uri_parts, 0, 4));

switch ($route) {
    case 'auth/login':
        require __DIR__ . '/routes/auth.php';
        break;
    case 'api-keys':
    case 'api-keys/':
        require __DIR__ . '/routes/api-keys.php';
        break;
    case 'billing/payments':
        require __DIR__ . '/routes/billing.php';
        break;
    case 'medical/devices/data':
        require __DIR__ . '/routes/medical/devices.php';
        break;
    case 'medical/patients':
        require __DIR__ . '/routes/medical/patients.php';
        break;
    case 'medical/allergies':
        require __DIR__ . '/routes/medical/allergies.php';
        break;
    case 'medical/diagnoses':
        require __DIR__ . '/routes/medical/diagnoses.php';
        break;
    case 'logs/audit':
        require __DIR__ . '/routes/logs/audit.php';
        break;
    case 'logs/errors':
        require __DIR__ . '/routes/logs/errors.php';
        break;
    case 'logs/api-responses':
        require __DIR__ . '/routes/logs/responses.php';
        break;
    case 'health':
    case '':
        require __DIR__ . '/routes/health.php';
        break;

    default:
        if (preg_match('#^api-keys/(\d+)$#', $uri, $m) && $_SERVER['REQUEST_METHOD'] === 'DELETE') {
            $_GET['key_id'] = $m[1];
            require __DIR__ . '/routes/api-keys.php';
            break;
        }
        if (preg_match('#^medical/allergies/(\d+)$#', $uri, $m)) {
            $_GET['patient_id'] = $m[1];
            require __DIR__ . '/routes/medical/allergies.php';
            break;
        }
        if (preg_match('#^medical/diagnoses/(\d+)$#', $uri, $m)) {
            $_GET['patient_id'] = $m[1];
            require __DIR__ . '/routes/medical/diagnoses.php';
            break;
        }

        $response->json(['error' => 'Route not found', 'path' => $uri], 404);
}
?>